
#include <iostream>
#include <vector>
#include <algorithm>
#include <stdint.h>

using namespace std;

struct force_t {
    int64_t x, y;

    int sign() const {
        if (y > 0 || (y == 0 && x > 0))
            return 1;
        else if (y < 0 || (y == 0 && x < 0))
            return -1;
        else
            return 0;
    }
    bool operator== (const force_t& other) const {
        return (x == other.x && y == other.y);
    }
    bool operator!= (const force_t& other) const {
        return !(*this == other);
    }
    bool operator<= (const force_t& other) const {
        int64_t l = x*x + y*y;
        int64_t other_l = other.x*other.x + other.y*other.y;
        bool s = (y > 0 || (y == 0 && x >= 0));
        bool other_s = (other.y > 0 || (other.y == 0 && other.x >= 0));
        int64_t q = x*other.y - y*other.x;
        if (s == other_s) {
            return (q > 0 || (q == 0 && l <= other_l));
        }
        else if (s) {
            return true;
        }
        else {
            return false;
        }
    }
    bool operator< (const force_t& other) const {
        return (*this <= other && *this != other);
    }
    bool operator>= (const force_t& other) const {
        return !(*this < other);
    }
    bool operator> (const force_t& other) const {
        return !(*this <= other);
    }
    force_t operator- () const {
        return force_t{-x, -y};
    }
};

int main()
{
    cin.sync_with_stdio(false);

    int N;
    cin >> N;

    vector<force_t> forces(N, force_t{0, 0});
    for (int n = 0; n < N; n ++) {
        int x, y;
        cin >> x >> y;
        forces[n] = force_t{x, y};
    }

    sort(forces.begin(), forces.end());

    vector<force_t> pf;
    vector<force_t> nf;

    force_t sum{0, 0};

    for (int j = 0; j < forces.size(); j ++) {
        force_t f = forces[j];
        if (f.sign() >= 0) {
            sum.x += f.x;
            sum.y += f.y;
            pf.push_back(f);
        }
        else {
            sum.x -= f.x;
            sum.y -= f.y;
            nf.push_back(f);
        }
    }

    int64_t M = sum.x*sum.x + sum.y*sum.y;

    int pj = 0;
    int nj = 0;
    while (pj < pf.size() || nj < nf.size()) {
        if ((pj < pf.size() && nj < nf.size() && -pf[pj] <= nf[nj]) || nj == nf.size()) {
            sum.x -= 2*pf[pj].x;
            sum.y -= 2*pf[pj].y;
            pj += 1;
        }
        else {
            sum.x += 2*nf[nj].x;
            sum.y += 2*nf[nj].y;
            nj += 1;
        }
        int64_t m = sum.x*sum.x + sum.y*sum.y;
        if (m > M) {
            M = m;
        }
    }

    cout << 25*M << '\n';
}

