
#include <iostream>
#include <vector>
#include <map>
#include <cassert>

using namespace std;

int main()
{
    cin.sync_with_stdio(false);

    int N;
    cin >> N;

    vector<int> rows(N, 0);
    vector<int> cols(N, 0);

    for (int n = 0; n < N; n ++) {
        cin >> rows[n] >> cols[n];
    }

    map<int, int> rowidxs;
    map<int, int> colidxs;

    vector< vector<int> > G;

    for (int n = 0; n < N; n ++) {
        int p, q;
        map<int, int>::iterator rowidx = rowidxs.find(rows[n]);
        if (rowidx != rowidxs.end()) {
            p = rowidx->second;
        }
        else {
            p = rowidxs[rows[n]] = G.size();
            G.push_back(vector<int>());
        }
        map<int, int>::iterator colidx = colidxs.find(cols[n]);
        if (colidx != colidxs.end()) {
            q = colidx->second;
        }
        else {
            q = colidxs[cols[n]] = G.size();
            G.push_back(vector<int>());
        }
        G[p].push_back(q);
        G[q].push_back(p);
    }

    vector<int> component(G.size(), -1);
    vector<int> oddness;

    for (int p = 0; p < G.size(); p ++) {
        if (component[p] != -1) continue;
        int C = oddness.size();
        oddness.push_back(0);
        vector<int> stack(1, p);
        while (!stack.empty()) {
            int p = stack.back();
            stack.pop_back();
            if (component[p] != -1) continue;
            component[p] = C;
            for (int j = 0; j < G[p].size(); j ++) {
                int q = G[p][j];
                if (component[q] == -1) {
                    stack.push_back(q);
                }
            }
            if (G[p].size() % 2 == 1) {
                oddness[C] ++;
            }
        }
    }

    int Z = 0;
    for (int j = 0; j < oddness.size(); j ++) {
        int d = oddness[j];
        assert(d % 2 == 0);
        if (d == 0) {
            Z ++;
        }
        else {
            Z += d / 2;
        }
    }

    cout << Z << '\n';
}

