
#include <iostream>
#include <vector>
#include <algorithm>
#include <cstdlib>

struct pt {
    long long x;
    long long y;

    pt(): x(0), y(0) {};
    pt(long long _x, long long _y): x(_x), y(_y) {};
};

long long line(const pt& a, const pt& b, const pt& c)
{
    return (a.x-b.x)*(a.y-c.y)-(a.y-b.y)*(a.x-c.x);
}

int sign(const pt& a, const pt& b, const pt& c)
{
    long long l = line(a, b, c);
    return l > 0 ? 1 : l < 0 ? -1 : 0;
}

bool inside(const pt& a, const pt& b, const pt& c, const pt& d)
{
    long long l1 = line(a, b, d);
    long long l2 = line(b, c, d);
    long long l3 = line(c, a, d);
    return (l1 > 0 && l2 > 0 && l3 > 0) || (l1 < 0 && l2 < 0 && l3 < 0);
}

using namespace std;

int main()
{
    ios_base::sync_with_stdio(false);

    int N;
    cin >> N;

    vector<pt> P(N);
    for (int k = 0; k < N; k++)
        cin >> P[k].x >> P[k].y;

    pt Z;
    srand(0);
    bool valid = false;
    while (!valid) {
        Z = pt(rand() % 100000, rand() % 100000);
        valid = true;
        for (int i = 0; i < N-1; i++) {
            for (int j = i+1; j < N; j++) {
                if (line(Z, P[i], P[j]) == 0) {
                    valid = false;
                    break;
                }
            }
            if (!valid) break;
        }
    }

    vector<int> AB0(N*N);
    for (int i = 0; i < N; i++)
        for (int j = i; j < N; j++) {
            int S = 0;
            for (int k = 0; k < N; k++) {
                if (inside(Z, P[i], P[j], P[k]))
                    S++;
            }
            AB0[i*N+j] = S*sign(Z, P[i], P[j]);
            AB0[j*N+i] = -AB0[i*N+j];
        }

    int X = 0;

    for (int i = 0; i < N-2; i++)
        for (int j = i+1; j < N-1; j++)
            for (int k = j+1; k < N; k++) {
                int sij = AB0[i*N+j] - sign(Z, P[i], P[j])*(int)inside(Z, P[i], P[j], P[k]);
                int sjk = AB0[j*N+k] - sign(Z, P[j], P[k])*(int)inside(Z, P[j], P[k], P[i]);
                int ski = AB0[k*N+i] - sign(Z, P[k], P[i])*(int)inside(Z, P[k], P[i], P[j]);
                if (sij + sjk + ski == 0)
                    X++;
            }

    cout << X << '\n';
}

