
#include <iostream>
#include <vector>

using namespace std;

struct cell {
    int x;
    int k;
    int s;
    cell(): x(0), k(0), s(0) {};
    cell(int _x, int _k, int _s): x(_x), k(_k), s(_s) {};
};

void merge(vector<cell> &A, vector<cell> &T, int l, int r)
{
    if (r-l <= 1)
        return;

    int c = (l+r)/2;
    merge(A, T, l, c);
    merge(A, T, c, r);

    int i = l;
    int j = c;
    int k = l;

    while (i < c || j < r) {
        if (j == r || (i < c && A[i].x > A[j].x)) {
            T[k++] = cell(A[i].x, A[i].k, A[i].s+j-c);
            i++;
        }
        else {
            T[k++] = cell(A[j].x, A[j].k, A[j].s+c-i);
            j++;
        }
    }

    for (int k = l; k < r; k++)
        A[k] = T[k];
}

int main()
{
    ios_base::sync_with_stdio(false);

    int N;
    cin >> N;
    vector<cell> A(N);
    for (int k = 0; k < N; k++) {
        int x;
        cin >> x;
        A[k] = cell(x, k, 0);
    }

    vector<cell> T(N);
    merge(A, T, 0, N);

    vector<int> S(N, 0);
    for (int k = 0; k < N; k++) {
        S[A[k].k] = A[k].s;
    }

    for (int k = 0; k < N; k++) {
        if (k > 0) cout << ' ';
        cout << S[k];
    }
    cout << '\n';

    return 0;
}

