{$A+,B-,D+,E-,F-,G-,I+,L+,N+,O-,P-,Q-,R-,S+,T-,V+,X+,Y+}
{$M 16384,0,655360}

program Agents;

const MaxN = 10;
const MaxM = 10000;

var N, M: integer;
var Xs, Ys: array[0..MaxN] of extended;
var graph: array[1..MaxM] of integer;
var D: array[0..MaxN, 0..MaxN] of extended;
var S, F: array[0..MaxN] of extended;
var A, B: extended;
var prev, next: integer;
var i, j, k: integer;

begin

    assign(input, 'agents.dat');
    reset(input);
    read(N);
    Xs[0] := 0.0; Ys[0] := 0.0;
    for k := 1 to N do
        read(Xs[k], Ys[k]);
    read(M);
    for k := 1 to M do
        read(graph[k]);
    close(input);

    for i := 0 to N do
        for j := 0 to N do
        begin
            A := Xs[i]-Xs[j];
            B := Ys[i]-Ys[j];
            D[i,j] := sqrt(A*A+B*B);
        end;

    S[0] := 0.0;
    for k := 1 to N do
        S[k] := -1;

    prev := 0;
    for k := 1 to M do
    begin
        next := graph[k];
        for i := 0 to N do
        begin
            A := -1;
            if S[i] >= 0 then
                A := S[i]+D[prev,next];
            if i = prev then
                for j := 0 to N do
                    if S[j] >= 0 then
                    begin
                        B := S[j]+D[j,next];
                        if (A < 0) or (A > B) then
                            A := B;
                    end;
            F[i] := A;
        end;
        for i := 0 to N do
            S[i] := F[i];
        prev := next;
    end;

    A := -1;
    for i := 0 to N do
        if S[i] >= 0 then
            if (A < 0) or (A > S[i]) then
                A := S[i];

    assign(output, 'agents.sol');
    rewrite(output);
    writeln(A);
    close(output);

end.
